/* - Spatial full -
 * This example simply displays the spatial info if it is attached and displays the acceleration data
 * for each axis as it is changing in pretty much raw form.  It also allows for modifying the sensitivity of
 * each axis that is availabl on the attached spatial.

 * Please note that this example was designed to work with only one Phidget Spatial connected.
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License.
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package Spatial;

import com.phidgets.SpatialPhidget;
import com.phidgets.PhidgetException;
import graphics.CompassBearingGraphPanel;
import graphics.GyroGraphPanel;
import graphics.MagFieldGraphPanel;
import graphics.MotionGraphPanel;
import java.util.ArrayList;

import javax.swing.JOptionPane;

import listeners.*;

public class Spatial extends javax.swing.JFrame {

    private static String runArgs[];
    private SpatialPhidget spatial;
    private SpatialAttachListener attach_listener;
    private SpatialDetachListener detach_listener;
    private SpatialErrorListener error_listener;
    private SpatialSpatialDataListener spatialData_listener;
    private MotionGraphPanel graphPanel;
    private MagFieldGraphPanel magFieldGraphPanel;
    private GyroGraphPanel gyroGraphPanel;
    private CompassBearingGraphPanel compassBearingGraphPanel;
    private Double[] gyroHeading = {0.0, 0.0, 0.0}; //degrees
    private Double lastTime;
    private ArrayList<Double[]> compassBearingFilter = new ArrayList<Double[]>();

    /** Creates new form Spatial */
    public Spatial() {
        initComponents();
        initCustomComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        attachedTxt = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        nameTxt = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        serialTxt = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        versionTxt = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        numAccelAxesTxt = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        numGyroAxesTxt = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        numCompassAxesTxt = new javax.swing.JTextField();
        jPanel2 = new javax.swing.JPanel();
        dataRateScrl = new javax.swing.JSlider();
        dataRateTxt = new javax.swing.JTextField();
        jPanel3 = new javax.swing.JPanel();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        accelXTxt = new javax.swing.JTextField();
        accelYTxt = new javax.swing.JTextField();
        accelZTxt = new javax.swing.JTextField();
        jPanel4 = new javax.swing.JPanel();
        jLabel11 = new javax.swing.JLabel();
        gyroXTxt = new javax.swing.JTextField();
        jLabel12 = new javax.swing.JLabel();
        gyroYTxt = new javax.swing.JTextField();
        jLabel13 = new javax.swing.JLabel();
        gyroZTxt = new javax.swing.JTextField();
        zeroGyroBtn = new javax.swing.JButton();
        jPanel5 = new javax.swing.JPanel();
        jLabel14 = new javax.swing.JLabel();
        gyroXTxt1 = new javax.swing.JTextField();
        jLabel15 = new javax.swing.JLabel();
        gyroYTxt1 = new javax.swing.JTextField();
        jLabel16 = new javax.swing.JLabel();
        gyroZTxt1 = new javax.swing.JTextField();
        pitchAngleTxt = new javax.swing.JTextField();
        rollAngleTxt = new javax.swing.JTextField();
        bearingTxt = new javax.swing.JTextField();
        jLabel17 = new javax.swing.JLabel();
        jLabel18 = new javax.swing.JLabel();
        jLabel19 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Spatial-full");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });
        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Spatial Info"));
        jPanel1.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        attachedTxt.setEditable(false);
        jPanel1.add(attachedTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(72, 22, 223, -1));

        jLabel1.setText("Attached:");
        jPanel1.add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 25, -1, -1));

        nameTxt.setBackground(javax.swing.UIManager.getDefaults().getColor("TextField.disabledBackground"));
        nameTxt.setColumns(20);
        nameTxt.setEditable(false);
        nameTxt.setLineWrap(true);
        nameTxt.setRows(3);
        nameTxt.setTabSize(2);
        nameTxt.setWrapStyleWord(true);
        jScrollPane1.setViewportView(nameTxt);

        jPanel1.add(jScrollPane1, new org.netbeans.lib.awtextra.AbsoluteConstraints(72, 48, 223, -1));

        jLabel2.setText("Name:");
        jPanel1.add(jLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 48, -1, -1));

        serialTxt.setEditable(false);
        jPanel1.add(serialTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(72, 114, 223, -1));

        jLabel3.setText("Serial No.:");
        jPanel1.add(jLabel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 117, -1, -1));

        versionTxt.setEditable(false);
        jPanel1.add(versionTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(72, 140, 223, -1));

        jLabel4.setText("Version:");
        jPanel1.add(jLabel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 143, -1, -1));

        numAccelAxesTxt.setEditable(false);
        jPanel1.add(numAccelAxesTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(125, 166, 170, -1));

        jLabel5.setText("Acceleration Axes:");
        jPanel1.add(jLabel5, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 169, -1, -1));

        jLabel6.setText("Gyro Axes:");
        jPanel1.add(jLabel6, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 195, -1, -1));

        numGyroAxesTxt.setEditable(false);
        jPanel1.add(numGyroAxesTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(125, 192, 170, -1));

        jLabel7.setText("Compass Axes:");
        jPanel1.add(jLabel7, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 221, -1, -1));

        numCompassAxesTxt.setEditable(false);
        jPanel1.add(numCompassAxesTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(125, 218, 170, -1));

        getContentPane().add(jPanel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 11, 313, 250));

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Data Rate"));
        jPanel2.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        dataRateScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                dataRateScrlStateChanged(evt);
            }
        });
        jPanel2.add(dataRateScrl, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 33, 175, -1));

        dataRateTxt.setEditable(false);
        jPanel2.add(dataRateTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(259, 33, 36, -1));

        getContentPane().add(jPanel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 270, 313, 68));

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Acceleration Data"));
        jPanel3.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jLabel8.setText("X");
        jPanel3.add(jLabel8, new org.netbeans.lib.awtextra.AbsoluteConstraints(41, 25, 15, -1));

        jLabel9.setText("Y");
        jPanel3.add(jLabel9, new org.netbeans.lib.awtextra.AbsoluteConstraints(41, 51, 15, -1));

        jLabel10.setText("Z");
        jPanel3.add(jLabel10, new org.netbeans.lib.awtextra.AbsoluteConstraints(41, 77, 15, -1));

        accelXTxt.setEditable(false);
        jPanel3.add(accelXTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(60, 22, 67, -1));

        accelYTxt.setEditable(false);
        jPanel3.add(accelYTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(60, 48, 67, -1));

        accelZTxt.setEditable(false);
        jPanel3.add(accelZTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(60, 74, 67, -1));

        getContentPane().add(jPanel3, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 350, 140, 110));

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder("Gyro Data"));
        jPanel4.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jLabel11.setText("X");
        jPanel4.add(jLabel11, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 25, -1, -1));

        gyroXTxt.setEditable(false);
        jPanel4.add(gyroXTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(70, 22, 67, -1));

        jLabel12.setText("Y");
        jPanel4.add(jLabel12, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 51, 17, -1));

        gyroYTxt.setEditable(false);
        jPanel4.add(gyroYTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(70, 48, 67, -1));

        jLabel13.setText("Z");
        jPanel4.add(jLabel13, new org.netbeans.lib.awtextra.AbsoluteConstraints(50, 77, 12, -1));

        gyroZTxt.setEditable(false);
        jPanel4.add(gyroZTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(70, 74, 67, -1));

        zeroGyroBtn.setText("Zero");
        zeroGyroBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                zeroGyroBtnActionPerformed(evt);
            }
        });
        jPanel4.add(zeroGyroBtn, new org.netbeans.lib.awtextra.AbsoluteConstraints(77, 100, -1, -1));

        getContentPane().add(jPanel4, new org.netbeans.lib.awtextra.AbsoluteConstraints(170, 350, 150, 130));

        jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder("Compass Data"));
        jPanel5.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jLabel14.setText("X");
        jPanel5.add(jLabel14, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 36, -1, -1));

        gyroXTxt1.setEditable(false);
        jPanel5.add(gyroXTxt1, new org.netbeans.lib.awtextra.AbsoluteConstraints(28, 33, 65, -1));

        jLabel15.setText("Y");
        jPanel5.add(jLabel15, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 62, -1, -1));

        gyroYTxt1.setEditable(false);
        jPanel5.add(gyroYTxt1, new org.netbeans.lib.awtextra.AbsoluteConstraints(28, 59, 65, -1));

        jLabel16.setText("Z");
        jPanel5.add(jLabel16, new org.netbeans.lib.awtextra.AbsoluteConstraints(18, 88, -1, -1));

        gyroZTxt1.setEditable(false);
        jPanel5.add(gyroZTxt1, new org.netbeans.lib.awtextra.AbsoluteConstraints(28, 85, 65, -1));

        pitchAngleTxt.setEditable(false);
        jPanel5.add(pitchAngleTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(217, 33, 78, -1));

        rollAngleTxt.setEditable(false);
        jPanel5.add(rollAngleTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(217, 59, 78, -1));

        bearingTxt.setEditable(false);
        jPanel5.add(bearingTxt, new org.netbeans.lib.awtextra.AbsoluteConstraints(217, 85, 78, -1));

        jLabel17.setText("Pitch Angle");
        jPanel5.add(jLabel17, new org.netbeans.lib.awtextra.AbsoluteConstraints(145, 36, -1, -1));

        jLabel18.setText("Roll Angle");
        jPanel5.add(jLabel18, new org.netbeans.lib.awtextra.AbsoluteConstraints(145, 62, -1, -1));

        jLabel19.setText("Bearing");
        jPanel5.add(jLabel19, new org.netbeans.lib.awtextra.AbsoluteConstraints(145, 88, -1, -1));

        getContentPane().add(jPanel5, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 490, 313, 120));

        pack();
    }// </editor-fold>//GEN-END:initComponents

    //initializes GUI with custom panels
    private void initCustomComponents() {

        graphPanel = new MotionGraphPanel();
        graphPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Acceleration Vector"));
        graphPanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());
        getContentPane().add(graphPanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(335, 11, 290, 290));
        graphPanel.setVisible(false);
        graphPanel.setEnabled(false);

        magFieldGraphPanel = new MagFieldGraphPanel();
        magFieldGraphPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Magnectic Field Vector"));
        magFieldGraphPanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());
        getContentPane().add(magFieldGraphPanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(640, 11, 290, 290));
        magFieldGraphPanel.setVisible(false);
        magFieldGraphPanel.setEnabled(false);

        gyroGraphPanel = new GyroGraphPanel();
        gyroGraphPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Gyroscope Headings"));
        gyroGraphPanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());
        getContentPane().add(gyroGraphPanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(335, 300, 290, 290));
        gyroGraphPanel.setVisible(false);
        gyroGraphPanel.setEnabled(false);

        compassBearingGraphPanel = new CompassBearingGraphPanel();
        compassBearingGraphPanel.setBorder(javax.swing.BorderFactory.createTitledBorder("Compass Bearing"));
        compassBearingGraphPanel.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());
        getContentPane().add(compassBearingGraphPanel, new org.netbeans.lib.awtextra.AbsoluteConstraints(640, 300, 290, 290));
        compassBearingGraphPanel.setVisible(false);
        compassBearingGraphPanel.setEnabled(false);
        pack();
    }

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        try {

            spatial = new SpatialPhidget();

            /* jPanel2.setVisible(false);
            jPanel2.setEnabled(false);
            jPanel3.setVisible(false);
            jPanel3.setEnabled(false);
            jPanel4.setVisible(false);
            jPanel4.setEnabled(false);
            jPanel5.setVisible(false);
            jPanel5.setEnabled(false);
             */
            gyroHeading[0] = 0.0;
            gyroHeading[1] = 0.0;
            gyroHeading[2] = 0.0;
            lastTime = 0.0;

            dataRateScrl.setEnabled(false);
            dataRateTxt.setEnabled(false);
            accelXTxt.setEnabled(false);
            accelYTxt.setEnabled(false);
            accelZTxt.setEnabled(false);
            gyroXTxt.setEnabled(false);
            gyroYTxt.setEnabled(false);
            gyroZTxt.setEnabled(false);
            zeroGyroBtn.setEnabled(false);
            gyroXTxt1.setEnabled(false);
            gyroYTxt1.setEnabled(false);
            gyroZTxt1.setEnabled(false);
            pitchAngleTxt.setEnabled(false);
            rollAngleTxt.setEnabled(false);
            bearingTxt.setEnabled(false);

            attach_listener = new SpatialAttachListener(this, this.jPanel2, this.jPanel3,
                    this.jPanel4, this.jPanel5, this.attachedTxt, this.nameTxt,
                    this.serialTxt, this.versionTxt, this.numAccelAxesTxt, this.numGyroAxesTxt,
                    this.numCompassAxesTxt, this.dataRateScrl, this.dataRateTxt,
                    this.accelXTxt, this.accelYTxt, this.accelZTxt, this.gyroXTxt, this.gyroYTxt, this.gyroZTxt,
                    this.zeroGyroBtn, this.gyroXTxt1, this.gyroYTxt1, this.gyroZTxt1,
                    this.pitchAngleTxt, this.rollAngleTxt, this.bearingTxt, this.gyroHeading, this.lastTime, this.graphPanel, this.magFieldGraphPanel,
                    this.gyroGraphPanel, this.compassBearingGraphPanel);

            detach_listener = new SpatialDetachListener(this, this.attachedTxt, this.nameTxt,
                    this.serialTxt, this.versionTxt, this.numAccelAxesTxt, this.numGyroAxesTxt,
                    this.numCompassAxesTxt, this.dataRateScrl, this.dataRateTxt,
                    this.accelXTxt, this.accelYTxt, this.accelZTxt, this.gyroXTxt, this.gyroYTxt, this.gyroZTxt,
                    this.zeroGyroBtn, this.gyroXTxt1, this.gyroYTxt1, this.gyroZTxt1,
                    this.pitchAngleTxt, this.rollAngleTxt, this.bearingTxt, this.gyroHeading, this.lastTime,
                    this.graphPanel, this.magFieldGraphPanel, this.gyroGraphPanel, this.compassBearingGraphPanel);

            error_listener = new SpatialErrorListener(this);

            spatialData_listener = new SpatialSpatialDataListener(this.accelXTxt, this.accelYTxt, this.accelZTxt,
                    this.gyroXTxt, this.gyroYTxt, this.gyroZTxt, this.gyroXTxt1, this.gyroYTxt1, this.gyroZTxt1,
                    this.gyroHeading, this.lastTime, this.pitchAngleTxt, this.rollAngleTxt, this.bearingTxt,
                    this.compassBearingFilter, this.graphPanel, this.magFieldGraphPanel, this.gyroGraphPanel,
                    this.compassBearingGraphPanel);

            spatial.addAttachListener(attach_listener);

            spatial.addDetachListener(detach_listener);
            spatial.addErrorListener(error_listener);
            spatial.addSpatialDataListener(spatialData_listener);

            if ((runArgs.length > 1) && (runArgs[1].equals("remote"))) {
                spatial.open(Integer.parseInt(runArgs[0]), null);
            } else if (runArgs.length > 0) {
                spatial.open(Integer.parseInt(runArgs[0]));
            } else {
                spatial.openAny();
            }

        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_formWindowOpened

    private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
        try {
            spatial.removeSpatialDataListener(spatialData_listener);
            spatial.removeErrorListener(error_listener);
            spatial.removeDetachListener(detach_listener);
            spatial.removeAttachListener(attach_listener);

            spatial.close();
            spatial = null;

            dispose();
            System.exit(0);
        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            dispose();
            System.exit(0);
        }
    }//GEN-LAST:event_formWindowClosed

    private void dataRateScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_dataRateScrlStateChanged
        if (dataRateScrl.isEnabled()) {
            try {
                spatial.setDataRate(dataRateScrl.getValue());
                dataRateTxt.setText(Integer.toString(dataRateScrl.getValue()));
            } catch (PhidgetException ex) {
                //Throws an exception if setting a data rate that is not a multiple of 8, or outside the range 4-1000
            }
        }
    }//GEN-LAST:event_dataRateScrlStateChanged

    private void zeroGyroBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_zeroGyroBtnActionPerformed
        try {
            spatial.zeroGyro();

        } catch (PhidgetException ex) {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
        try {
            Thread.sleep(100);
        } catch (InterruptedException ex) {
        }

        gyroHeading[0] = 0.0;
        gyroHeading[1] = 0.0;
        gyroHeading[2] = 0.0;
    }//GEN-LAST:event_zeroGyroBtnActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        runArgs = args;
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                new Spatial().setVisible(true);
            }
        });
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField accelXTxt;
    private javax.swing.JTextField accelYTxt;
    private javax.swing.JTextField accelZTxt;
    private javax.swing.JTextField attachedTxt;
    private javax.swing.JTextField bearingTxt;
    private javax.swing.JSlider dataRateScrl;
    private javax.swing.JTextField dataRateTxt;
    private javax.swing.JTextField gyroXTxt;
    private javax.swing.JTextField gyroXTxt1;
    private javax.swing.JTextField gyroYTxt;
    private javax.swing.JTextField gyroYTxt1;
    private javax.swing.JTextField gyroZTxt;
    private javax.swing.JTextField gyroZTxt1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea nameTxt;
    private javax.swing.JTextField numAccelAxesTxt;
    private javax.swing.JTextField numCompassAxesTxt;
    private javax.swing.JTextField numGyroAxesTxt;
    private javax.swing.JTextField pitchAngleTxt;
    private javax.swing.JTextField rollAngleTxt;
    private javax.swing.JTextField serialTxt;
    private javax.swing.JTextField versionTxt;
    private javax.swing.JButton zeroGyroBtn;
    // End of variables declaration//GEN-END:variables
}
